CREATE FUNCTION UFD_PESQ_EST_PROD_SIMILARIDADE (@SEQ_STRING1 VARCHAR(500), @SCORE INT) 
RETURNS 
	@PRODUTOS TABLE (CD_PROD INT, DS_PROD VARCHAR(MAX) COLLATE SQL_Latin1_General_CP1_CI_AS) 
WITH ENCRYPTION
AS
BEGIN

	DECLARE @POSICAO INT;
	DECLARE @PALAVRA VARCHAR(MAX);
	DECLARE @QTDE_PALAVRAS INT;

	DECLARE @TBL_COMPARE TABLE(STRING VARCHAR(MAX) COLLATE SQL_Latin1_General_CP1_CI_AS);

	SET @POSICAO = 1;

	SET @PALAVRA = ''

	WHILE @POSICAO < LEN(@SEQ_STRING1)
	BEGIN
		IF CHAR(ASCII(SUBSTRING(@SEQ_STRING1,@POSICAO,1))) IN(' ','/')
			BEGIN
				IF @PALAVRA <> '' 
					BEGIN
						INSERT INTO @TBL_COMPARE VALUES (@PALAVRA);
						SELECT @PALAVRA = ''
					END
			END
		ELSE
			BEGIN
				SELECT @PALAVRA = @PALAVRA + CHAR(ASCII(SUBSTRING(@SEQ_STRING1,@POSICAO,1)));
			END
		SELECT @POSICAO = @POSICAO + 1;
	END

	INSERT INTO @TBL_COMPARE VALUES (@PALAVRA);

	SELECT @QTDE_PALAVRAS = COUNT(*) FROM @TBL_COMPARE;

	INSERT INTO
		@PRODUTOS
	SELECT
		CD_PROD,
		DS_PROD
	FROM 
		EST_PROD P, @TBL_COMPARE T
	WHERE
		CHARINDEX(T.STRING,P.DS_PROD) <> 0
	GROUP BY
		CD_PROD,
		DS_PROD
	HAVING
		COUNT(P.CD_PROD) >= @SCORE;

	RETURN;
END